/*
	                 PROCESS FORKING REVISITED		

  This program demonstrates some interesting issues about fork()

*/

#include <stdio.h>
#include <sys/ipc.h>  

main()
{
	int x=0, pid;

	printf("Hello!");

	/*
	   After forking, we make the parent and its two children
           increment x in different ways to illustrate that they
	   have different copies of x
	*/
	if ((pid = fork()) == 0) {

	  /* Child */
	  printf("\nChild:\t Address of x: %x\t Value of x: %d \n", &x, x);
	  x = 20;
	  printf("Child:\t Address of x: %x\t Value of x: %d \n", &x, x);
	}
	else {

	  /* Parent */
	  waitpid(pid, NULL, 0);
	  printf("\nParent:\t Address of x: %x\t Value of x: %d \n", &x, x);
	  x = 10;
	  printf("Parent:\t Address of x: %x\t Value of x: %d \n", &x, x);

	}
}

/* Points to ponder:

	1. Why is Hello! printed twice?
	2. Though the address of x is the same in the parent and in the
	   child, they contain different values. How is this possible?

*/

